package com.hero;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.ui.dialog.AvailableModifiersDialog;
import com.hero.util.XMLUtility;
import com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class AppPrefs {

	public static final int NEVER = 3;

	public static final int ALWAYS = 1;

	public static final int PROMPT = 2;

	private int state = 0;

	private int sizeX = 800;

	private int sizeY = 550;

	private int screenX = 0;

	private int screenY = 0;

	private String saveDir = "";

	private String exportDir = "";

	private String imageDir = "";

	private String templateDir = "";

	private String defaultExportDir = "";

	private String defaultRulesDir = "";

	private String prefabDir = "";

	private String rulesDir = "";

	private String lastRule = "";

	private int maxMemory = 128;

	private boolean loadCharacters = true;

	private boolean loadPrefabs = true;

	private boolean restoreWindow = true;

	private boolean rememberDialogPosition = true;

	private int dialogX = 800;

	private int dialogY = 550;

	private int dialogScreenX = 0;

	private int dialogScreenY = 0;

	private int modX = 0;

	private int modY = 0;

	private int modScreenX = 0;

	private int modScreenY = 0;

	private int numberDigitsForRounding = 1;

	private String exportTemplateDir = "ExportTemplates";

	private boolean modifierIntelligenceOn = true;

	private boolean checkDuringEdit = true;

	private boolean removeIllegalMods = true;

	private boolean metric = true;

	private boolean displayActivePoints = true;

	private boolean useAbbreviations = false;

	private boolean useWG = true;

	private boolean useQuickAssign = true;

	private boolean confirmDelete = true;

	private boolean warnOnMultiple = true;

	private boolean showCommonLimitations = true;

	private ArrayList<String> recentFiles = new ArrayList<String>();

	private int tabPosition = 1;

	private Hashtable<String, Integer[]> tearOffPrefs = new Hashtable<String, Integer[]>();

	private ArrayList<String> sources;

	private int refreshTemplateOnRestore = 2;

	private int refreshRulesOnRestore = 2;

	private boolean showPopupDefinitions = false;

	private boolean showEquipmentPrefabsOnPowers = true;

	private boolean showPowersPrefabsOnEquipment = true;

	private boolean promptToExportImage = false;

	private String browserExecutablePath = null;

	private String defaultAIFormatPath = null;
	private String defaultAutomatonFormatPath = null;
	private String defaultBaseFormatPath = null;
	private String defaultComputerFormatPath = null;
	private String defaultHeroicFormatPath = null;
	private String defaultNormalFormatPath = null;
	private String defaultSuperheroicFormatPath = null;
	private String defaultVehicleFormatPath = null;

	private int minimumHeapSize = 32;
	private int maximumHeapSize = 64;

	private boolean flagForcedModifiers = true;

	public static final int ADD_MOST_EXPENSIVE = 1;

	public static final int ADD_LEAST_EXPENSIVE = 2;

	public static final int ADD_MOST_LEVELS = 3;

	public static final int ADD_LEAST_LEVELS = 4;

	public static final int ADD_BOTH = 5;

	public static final int ADD_PACKAGE_DEAL = 6;

	public static final int ADD_EXISTING = 7;

	public AppPrefs() {

	}

	public void setBrowserExecutablePath(String val) {
		browserExecutablePath = val;
	}

	public String getBrowserExecutablePath() {
		return browserExecutablePath;
	}

	public boolean getPromptToExportImage() {
		return promptToExportImage;
	}

	public void setPromptToExportImage(boolean val) {
		promptToExportImage = val;
	}

	public boolean flagForcedModifiers() {
		return flagForcedModifiers;
	}

	public void setFlagForcedModifiers(boolean val) {
		flagForcedModifiers = val;
	}

	public boolean getShowEquipmentPrefabsOnPowers() {
		return showEquipmentPrefabsOnPowers;
	}

	public void setShowEquipmentPrefabsOnPowers(boolean val) {
		showEquipmentPrefabsOnPowers = val;
	}

	public boolean getShowPowersPrefabsOnEquipment() {
		return showPowersPrefabsOnEquipment;
	}

	public void setShowPowersPrefabsOnEquipment(boolean val) {
		showPowersPrefabsOnEquipment = val;
	}

	public int getPackageDealConflictResolution() {
		return AppPrefs.ADD_BOTH;
	}

	public boolean showPopupDefinitions() {
		return showPopupDefinitions;
	}

	public void setShowPopupDefinitions(boolean val) {
		showPopupDefinitions = val;
	}

	public ArrayList<String> getSources() {
		if (sources == null) {
			sources = new ArrayList<String>();
		}
		if (sources.size() == 0 && !sourcesLocked) {
			ArrayList ret = (ArrayList) GenericObject.getAllSources().clone();
			if (ret.contains("Sidekick")
					&& ret.contains("Hero System Fifth Edition Rule Book")) {
				ret.remove("Sidekick");
			}
			return ret;
		}
		if (sources.contains("Sidekick")
				&& sources.contains("Hero System Fifth Edition Rule Book")) {
			sources.remove("Sidekick");
		}
		return sources;
	}

	private boolean sourcesLocked = false;

	public void setSources(ArrayList<String> val) {
		sources = val;
		sourcesLocked = true;
	}

	public Hashtable<String, Integer[]> getTearOffPrefs() {
		return tearOffPrefs;
	}

	public int getTabPosition() {
		return tabPosition;
	}

	public void setTabPosition(int val) {
		HeroDesigner.getInstance().mainPanel.setTabPlacement(val);
		tabPosition = val;
	}

	public void addRecentFile(File file) {
		if (recentFiles == null) {
			recentFiles = new ArrayList<String>();
		}
		if (recentFiles.contains(file.getAbsolutePath())) {
			recentFiles.remove(file.getAbsolutePath());
		}
		while (recentFiles.size() >= 10) {
			recentFiles.remove(9);
		}
		recentFiles.add(0, file.getAbsolutePath());
		HeroDesigner.getInstance().updateRecentMenu();
	}

	public ArrayList<String> getRecentFileList() {
		return recentFiles;
	}

	public String adjustTitle(String val) {
		String ret = "";
		for (int i = 0; i < val.length(); i++) {
			char c = val.charAt(i);
			if (Character.isLetterOrDigit(c)) {
				ret += "" + c;
			}
		}
		return ret;
	}

	protected void finishRestorePrefs() {
		try {
			File prefs = new File("appPrefs.xml");
			if (!prefs.exists()) {
				return;
			}
			SAXBuilder builder = new SAXBuilder(false);
			Document doc = builder.build(prefs);
			builder = null;
			Element root = doc.getRootElement();
			String check = null;
			Enumeration enumer = HeroDesigner.getInstance().mainPanel.components
					.keys();
			while (enumer.hasMoreElements()) {
				Object key = enumer.nextElement();
				String title = HeroDesigner.getInstance().mainPanel.components
						.get(key).toString();
				String adj = adjustTitle(title);
				int width = 0;
				int height = 0;
				int x = 0;
				int y = 0;
				int torn = 0;
				check = XMLUtility.getValue(root, adj + "WIDTH");
				if (check != null && check.trim().length() > 0) {
					try {
						width = Integer.parseInt(check);
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
				check = XMLUtility.getValue(root, adj + "HEIGHT");
				if (check != null && check.trim().length() > 0) {
					try {
						height = Integer.parseInt(check);
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
				check = XMLUtility.getValue(root, adj + "X");
				if (check != null && check.trim().length() > 0) {
					try {
						x = Integer.parseInt(check);
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
				check = XMLUtility.getValue(root, adj + "Y");
				if (check != null && check.trim().length() > 0) {
					try {
						y = Integer.parseInt(check);
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
				check = XMLUtility.getValue(root, adj + "TORN");
				if (check != null && check.trim().length() > 0) {
					try {
						torn = Integer.parseInt(check);
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
				if (width > 0 && height > 0) {
					Integer[] vals = new Integer[] { new Integer(width),
							new Integer(height), new Integer(x),
							new Integer(y), new Integer(torn) };
					tearOffPrefs.put(title, vals);
				}
			}
			HeroDesigner.getInstance().mainPanel.setStates();
			check = XMLUtility.getValue(root, "LOAD_CHARS");
			if (check != null && check.trim().toUpperCase().startsWith("N")) {
				loadCharacters = false;
			}
			check = XMLUtility.getValue(root,
					"SHOW_EQUIPMENT_PREFABS_ON_POWERS");
			if (check != null && check.trim().toUpperCase().startsWith("F")) {
				showEquipmentPrefabsOnPowers = false;
			}
			check = XMLUtility.getValue(root,
					"SHOW_POWERS_PREFABS_ON_EQUIPMENT");
			if (check != null && check.trim().toUpperCase().startsWith("F")) {
				showPowersPrefabsOnEquipment = false;
			}
			check = XMLUtility.getValue(root, "SHOW_POPUP_DEFINITIONS");
			if (check != null && check.trim().toUpperCase().startsWith("T")) {
				showPopupDefinitions = true;
			}
			check = XMLUtility.getValue(root, "TAB_POSITION");
			if (check != null) {
				try {
					int val = Integer.parseInt(check);
					if (val > 0 && val < 5) {
						HeroDesigner.getInstance().mainPanel
								.setTabPlacement(val);
						tabPosition = val;
					}
				} catch (Exception exp) {
				}
			}
			check = XMLUtility.getValue(root, "LOAD_PREFABS");
			if (check != null && check.trim().toUpperCase().startsWith("N")) {
				loadPrefabs = false;
			}

			check = XMLUtility.getValue(root, "SKILLSLIDER");
			if (check != null && check.trim().length() > 0) {
				try {
					int slider = Integer.parseInt(check);
					HeroDesigner.getInstance().mainPanel.skillsPanel.mainSplit
							.setDividerLocation(slider);
				} catch (Exception e) {
				}
			}
			check = XMLUtility.getValue(root, "PERKSLIDER");
			if (check != null && check.trim().length() > 0) {
				try {
					int slider = Integer.parseInt(check);
					HeroDesigner.getInstance().mainPanel.perksPanel.mainSplit
							.setDividerLocation(slider);
				} catch (Exception e) {
				}
			}
			check = XMLUtility.getValue(root, "TALENTSLIDER");
			if (check != null && check.trim().length() > 0) {
				try {
					int slider = Integer.parseInt(check);
					HeroDesigner.getInstance().mainPanel.talentsPanel.mainSplit
							.setDividerLocation(slider);
				} catch (Exception e) {
				}
			}
			check = XMLUtility.getValue(root, "MARTIALARTSLIDER");
			if (check != null && check.trim().length() > 0) {
				try {
					int slider = Integer.parseInt(check);
					HeroDesigner.getInstance().mainPanel.maneuversPanel.mainSplit
							.setDividerLocation(slider);
				} catch (Exception e) {
				}
			}
			check = XMLUtility.getValue(root, "POWERSLIDER");
			if (check != null && check.trim().length() > 0) {
				try {
					int slider = Integer.parseInt(check);
					HeroDesigner.getInstance().mainPanel.powersPanel.mainSplit
							.setDividerLocation(slider);
				} catch (Exception e) {
				}
			}
			check = XMLUtility.getValue(root, "DISADSLIDER");
			if (check != null && check.trim().length() > 0) {
				try {
					int slider = Integer.parseInt(check);
					HeroDesigner.getInstance().mainPanel.disadsPanel.mainSplit
							.setDividerLocation(slider);
				} catch (Exception e) {
				}
			}
			check = XMLUtility.getValue(root, "EQUIPMENTSLIDER");
			if (check != null && check.trim().length() > 0) {
				try {
					int slider = Integer.parseInt(check);
					HeroDesigner.getInstance().mainPanel.equipmentPanel.mainSplit
							.setDividerLocation(slider);
				} catch (Exception e) {
				}
			}

			if (loadCharacters) {
				java.util.List list = root.getChildren("CHARACTER");
				Iterator iter = list.iterator();
				while (iter.hasNext()) {
					if (!HeroDesigner.headless) {
						HeroDesigner.loadProgress
								.setString("Loading characters....");
					}
					Element el = (Element) iter.next();
					String file = XMLUtility.getValue(el, "FILE_LOC");
					File test = new File(file);
					if (!test.exists()) {
						continue;
					}
					if (file != null && file.trim().length() > 0) {
						HeroDesigner.getInstance().openHero(new File(file),
								true);
					}
				}
			}
			if (HeroDesigner.getInstance().getActiveTemplate() == null) {
				HeroDesigner.getInstance().setTemplate("Superheroic.hdt", true,
						false, true);
			}
			if (loadPrefabs) {
				java.util.List list = root.getChildren("PREFAB");
				Iterator iter = list.iterator();
				boolean added = false;
				while (iter.hasNext()) {
					if (!HeroDesigner.headless) {
						HeroDesigner.loadProgress
								.setString("Loading prefabs....");
					}
					Element el = (Element) iter.next();
					String file = XMLUtility.getValue(el, "FILE_LOC");
					File test = new File(file);
					if (!test.exists()) {
						continue;
					}
					if (file != null && file.trim().length() > 0) {
						try {
							Prefab pb = null;
							if (file.toUpperCase().endsWith(".HDP")) {
								pb = new Prefab(test, true);
								HeroDesigner.getInstance().loadedPrefabs
										.add(pb);
								String name = pb.getName().trim().length() == 0 ? "[unknown]"
										: pb.getName();
								JMenuItem item = new JMenuItem(name);
								item.addActionListener(HeroDesigner
										.getInstance().new PrefabActionListener(
										pb, item));
								HeroDesigner.getInstance().unloadPrefabMI
										.add(item);
								added = true;
							} else {
								continue;
							}
						} catch (Exception exp) {
							exp.printStackTrace();
							JOptionPane.showMessageDialog(
									HeroDesigner.getAppFrame(),
									"An error occurred loading previously loaded Prefabs.\n\nError Message: "
											+ exp.getMessage(),
									"Error loading prefabs",
									JOptionPane.ERROR_MESSAGE);
						}
					}
				}
				if (added && HeroDesigner.getInstance().mainPanel != null) {
					HeroDesigner.getInstance().mainPanel.updatePrefabs();
				}
			}
			// restore recently selected list of Modifiers...
			ArrayList<Modifier> recent = new ArrayList<Modifier>();
			Iterator iter = root.getChildren("MODIFIER").iterator();
			while (iter.hasNext()) {
				Element modifier = (Element) iter.next();
				String idCheck = XMLUtility.getValue(modifier, "XMLID");
				Modifier mod = null;
				if (idCheck != null && idCheck.trim().length() > 0) {
					LOOP: for (GenericObject comp : HeroDesigner
							.getActiveTemplate().getModifiers()) {
						if (comp.getXMLID().equals(idCheck)) {
							mod = (Modifier) comp.clone();
							break LOOP;
						}
					}
				}
				if (mod == null) {
					mod = Modifier.getInstance(modifier);
				}
				if (mod != null) {
					mod.restoreFromSave(modifier);
					if (mod.getDisplay() == null
							|| mod.getDisplay().trim().length() == 0) {
						mod.setDisplay(mod.getAlias());
					}
					mod.setFullDisplay(true);
					recent.add(mod);
				}
			}
			AvailableModifiersDialog.setRecentlySelectedList(recent);

			Element srcs = root.getChild("SOURCES");
			if (srcs == null || sources.size() == 0) {
				sources = GenericObject.getAllSources();
			}
		} catch (Exception exp) {
			exp.printStackTrace();
			JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(),
					"An error occurred restoring your saved preferences.\n\nError Message: "
							+ exp.getMessage(), "Error loading preferences",
					JOptionPane.ERROR_MESSAGE);
		}
	}

	protected void restorePrefs() {
		try {
			File prefs = new File("appPrefs.xml");
			if (!prefs.exists()) {
				return;
			}
			SAXBuilder builder = new SAXBuilder(false);
			Document doc = builder.build(prefs);
			builder = null;
			Element root = doc.getRootElement();
			String check = XMLUtility.getValue(root, "FRAME_STATE");
			if (check != null && check.trim().length() > 0) {
				try {
					state = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
					state = JFrame.NORMAL;
				}
			} else {
				state = JFrame.NORMAL;
			}

			Element srcs = root.getChild("SOURCES");
			if (srcs != null) {
				sources = new ArrayList<String>();
				Iterator iter = srcs.getChildren("SOURCE").iterator();
				while (iter.hasNext()) {
					Element s = (Element) iter.next();
					sources.add(s.getTextTrim());
				}
			}
			check = XMLUtility.getValue(root, "MINIMUM_HEAP_SIZE");
			if (check != null && check.trim().length() > 0) {
				try {
					minimumHeapSize = Integer.parseInt(check);
				} catch (Exception exp) {

				}
			}
			check = XMLUtility.getValue(root, "MAXIMUM_HEAP_SIZE");
			if (check != null && check.trim().length() > 0) {
				try {
					maximumHeapSize = Integer.parseInt(check);
				} catch (Exception exp) {

				}
			}
			
			check = XMLUtility.getValue(root, "REFRESH_TEMPLATE_ON_RESTORE");
			if (check != null && check.trim().length() > 0) {
				try {
					refreshTemplateOnRestore = Integer.parseInt(check);
					if (refreshTemplateOnRestore > 3) {
						refreshTemplateOnRestore = 3;
					}
					if (refreshTemplateOnRestore < 1) {
						refreshTemplateOnRestore = 3;
					}
				} catch (Exception exp) {
					refreshTemplateOnRestore = 3;
				}
			}

			check = XMLUtility.getValue(root, "BROWSER_PATH");
			if (check != null && check.trim().length() > 0) {
				browserExecutablePath = check.trim();
			}

			check = XMLUtility.getValue(root, "DEFAULT_AI_FORMAT");
			if (check != null && check.trim().length() > 0) {
				defaultAIFormatPath = check;
			}
			check = XMLUtility.getValue(root, "DEFAULT_AUTOMATON_FORMAT");
			if (check != null && check.trim().length() > 0) {
				defaultAutomatonFormatPath = check;
			}
			check = XMLUtility.getValue(root, "DEFAULT_BASE_FORMAT");
			if (check != null && check.trim().length() > 0) {
				defaultBaseFormatPath = check;
			}
			check = XMLUtility.getValue(root, "DEFAULT_COMPUTER_FORMAT");
			if (check != null && check.trim().length() > 0) {
				defaultComputerFormatPath = check;
			}
			check = XMLUtility.getValue(root, "DEFAULT_HEROIC_FORMAT");
			if (check != null && check.trim().length() > 0) {
				defaultHeroicFormatPath = check;
			}
			check = XMLUtility.getValue(root, "DEFAULT_NORMAL_FORMAT");
			if (check != null && check.trim().length() > 0) {
				defaultNormalFormatPath = check;
			}
			check = XMLUtility.getValue(root, "DEFAULT_SUPERHEROIC_FORMAT");
			if (check != null && check.trim().length() > 0) {
				defaultSuperheroicFormatPath = check;
			}
			check = XMLUtility.getValue(root, "DEFAULT_VEHICLE_FORMAT");
			if (check != null && check.trim().length() > 0) {
				defaultVehicleFormatPath = check;
			}

			check = XMLUtility.getValue(root, "REFRESH_RULES_ON_RESTORE");
			if (check != null && check.trim().length() > 0) {
				try {
					refreshRulesOnRestore = Integer.parseInt(check);
					if (refreshRulesOnRestore > 3) {
						refreshRulesOnRestore = 3;
					}
					if (refreshRulesOnRestore < 1) {
						refreshRulesOnRestore = 3;
					}
				} catch (Exception exp) {
					refreshTemplateOnRestore = 3;
				}
			}
			check = XMLUtility.getValue(root, "RESTORE_WINDOW");
			if (check != null && check.trim().toUpperCase().startsWith("N")) {
				restoreWindow = false;
			}
			check = XMLUtility.getValue(root, "MODIFIER_INTELLIGENCE");
			if (check != null && check.trim().toUpperCase().startsWith("N")) {
				modifierIntelligenceOn = false;
			}
			check = XMLUtility.getValue(root, "CHECK_MODS_DURING_EDIT");
			if (check != null && check.trim().toUpperCase().startsWith("N")) {
				checkDuringEdit = false;
			}
			check = XMLUtility.getValue(root, "REMOVE_ILLEGAL_MODS");
			if (check != null && check.trim().toUpperCase().startsWith("N")) {
				removeIllegalMods = false;
			}
			check = XMLUtility.getValue(root, "METRIC");
			if (check != null && check.trim().toUpperCase().startsWith("N")) {
				metric = false;
			} else {
				metric = true;
			}
			check = XMLUtility.getValue(root, "DISPLAYACTIVEPOINTS");
			if (check != null && check.trim().toUpperCase().startsWith("N")) {
				displayActivePoints = false;
			} else {
				displayActivePoints = true;
			}
			check = XMLUtility.getValue(root, "REMEMBER_DIALOG");
			if (check != null && check.trim().toUpperCase().startsWith("N")) {
				rememberDialogPosition = false;
			} else {
				rememberDialogPosition = true;
			}
			check = XMLUtility.getValue(root, "USE_ABBREVIATIONS");
			if (check != null && check.trim().toUpperCase().startsWith("N")) {
				useAbbreviations = false;
			} else {
				useAbbreviations = true;
			}
			check = XMLUtility.getValue(root, "USE_WG");
			if (check != null && check.trim().toUpperCase().startsWith("N")) {
				useWG = false;
			} else {
				useWG = true;
			}
			check = XMLUtility.getValue(root, "USE_QUICKASSIGN");
			if (check != null && check.trim().toUpperCase().startsWith("N")) {
				useQuickAssign = false;
			} else {
				useQuickAssign = true;
			}
			check = XMLUtility.getValue(root, "CONFIRM_DELETE");
			if (check != null && check.trim().toUpperCase().startsWith("N")) {
				confirmDelete = false;
			} else {
				confirmDelete = true;
			}
			check = XMLUtility.getValue(root, "WARN_ON_MULTIPLE");
			if (check != null && check.trim().toUpperCase().startsWith("N")) {
				warnOnMultiple = false;
			} else {
				warnOnMultiple = true;
			}
			check = XMLUtility.getValue(root, "SHOW_COMMON_LIMITATIONS");
			if (check != null && check.trim().toUpperCase().startsWith("N")) {
				showCommonLimitations = false;
			} else {
				showCommonLimitations = true;
			}
			check = XMLUtility.getValue(root, "PROMPT_TO_EXPORT_IMAGE");
			if (check != null && check.trim().toUpperCase().startsWith("N")) {
				promptToExportImage = false;
			} else {
				promptToExportImage = true;
			}
			check = XMLUtility.getValue(root, "FLAG_FORCED_MODIFIERS");
			if (check != null && check.trim().toUpperCase().startsWith("N")) {
				flagForcedModifiers = false;
			} else {
				flagForcedModifiers = true;
			}
			check = XMLUtility.getValue(root, "EXPORTTEMPLATEDIR");
			if (check != null) {
				exportTemplateDir = check;
			}
			check = XMLUtility.getValue(root, "NUMBERDIGITSROUNDING");
			if (check != null && check.trim().length() > 0) {
				try {
					numberDigitsForRounding = Integer.parseInt(check);
				} catch (Exception e) {
				}
			}
			check = XMLUtility.getValue(root, "DIALOGX");
			if (check != null && check.trim().length() > 0) {
				try {
					dialogX = Integer.parseInt(check);
				} catch (Exception e) {
				}
			}
			check = XMLUtility.getValue(root, "DIALOGY");
			if (check != null && check.trim().length() > 0) {
				try {
					dialogY = Integer.parseInt(check);
				} catch (Exception e) {
				}
			}
			check = XMLUtility.getValue(root, "DIALOGSCREENX");
			if (check != null && check.trim().length() > 0) {
				try {
					dialogScreenX = Integer.parseInt(check);
				} catch (Exception e) {
				}
			}
			check = XMLUtility.getValue(root, "DIALOGSCREENY");
			if (check != null && check.trim().length() > 0) {
				try {
					dialogScreenY = Integer.parseInt(check);
				} catch (Exception e) {
				}
			}
			check = XMLUtility.getValue(root, "MODX");
			if (check != null && check.trim().length() > 0) {
				try {
					modX = Integer.parseInt(check);
				} catch (Exception e) {
				}
			}
			check = XMLUtility.getValue(root, "MODY");
			if (check != null && check.trim().length() > 0) {
				try {
					modY = Integer.parseInt(check);
				} catch (Exception e) {
				}
			}
			check = XMLUtility.getValue(root, "MODSCREENX");
			if (check != null && check.trim().length() > 0) {
				try {
					modScreenX = Integer.parseInt(check);
				} catch (Exception e) {
				}
			}
			check = XMLUtility.getValue(root, "MODSCREENY");
			if (check != null && check.trim().length() > 0) {
				try {
					modScreenY = Integer.parseInt(check);
				} catch (Exception e) {
				}
			}
			check = XMLUtility.getValue(root, "SIZEX");
			sizeX = 800;
			if (check != null && check.trim().length() > 0) {
				try {
					sizeX = Integer.parseInt(check);
				} catch (Exception e) {
				}
			}
			check = XMLUtility.getValue(root, "SIZEY");
			sizeY = 550;
			if (check != null && check.trim().length() > 0) {
				try {
					sizeY = Integer.parseInt(check);
				} catch (Exception e) {
				}
			}
			check = XMLUtility.getValue(root, "SCREENX");
			if (check != null && check.trim().length() > 0) {
				try {
					screenX = Integer.parseInt(check);
				} catch (Exception e) {
					screenX = -1;
				}
			} else {
				screenX = -1;
			}
			check = XMLUtility.getValue(root, "SCREENY");
			if (check != null && check.trim().length() > 0) {
				try {
					screenY = Integer.parseInt(check);
				} catch (Exception e) {
					screenY = -1;
				}
			} else {
				screenY = -1;
			}

			check = XMLUtility.getValue(root, "SAVEDIR");
			if (check != null && check.trim().length() > 0) {
				saveDir = check;
			}
			check = XMLUtility.getValue(root, "EXPORTDIR");
			if (check != null && check.trim().length() > 0) {
				exportDir = check;
			}
			check = XMLUtility.getValue(root, "IMAGEDIR");
			if (check != null && check.trim().length() > 0) {
				imageDir = check;
			}
			check = XMLUtility.getValue(root, "TEMPLATEDIR");
			if (check != null && check.trim().length() > 0) {
				templateDir = check;
			}
			check = XMLUtility.getValue(root, "DEFAULTRULESDIR");
			if (check != null && check.trim().length() > 0) {
				defaultRulesDir = check;
			}
			check = XMLUtility.getValue(root, "DEFAULTEXPORTDIR");
			if (check != null && check.trim().length() > 0) {
				defaultExportDir = check;
			}
			check = XMLUtility.getValue(root, "PREFABDIR");
			if (check != null && check.trim().length() > 0) {
				prefabDir = check;
			}
			check = XMLUtility.getValue(root, "RULESDIR");
			if (check != null && check.trim().length() > 0) {
				rulesDir = check;
			}
			check = XMLUtility.getValue(root, "LASTRULE");
			if (check != null && check.trim().length() > 0) {
				lastRule = check;
			}

			java.util.List recentChars = root.getChildren("RECENT_FILE");
			Iterator recentIter = recentChars.iterator();
			recentFiles = new ArrayList<String>();
			while (recentIter.hasNext()) {
				Element el = (Element) recentIter.next();
				String loc = el.getTextTrim();
				if (loc.length() > 0) {
					File file = new File(loc);
					if (file.exists() && file.canRead()) {
						recentFiles.add(file.getAbsolutePath());
					}
				}
			}

		} catch (Exception exp) {
			exp.printStackTrace();
			JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(),
					"An error occurred restoring your saved preferences.\n\nError Message: "
							+ exp.getMessage(), "Error loading preferences",
					JOptionPane.ERROR_MESSAGE);
		}
	}

	protected void savePrefs() {
		try {
			Element root = new Element("APP_PREFS");
			if (HeroDesigner.getAppFrame().getExtendedState() == JFrame.NORMAL) {
				root.setAttribute("SIZEX",
						HeroDesigner.getAppFrame().getSize().width + "");
				root.setAttribute("SIZEY", ""
						+ HeroDesigner.getAppFrame().getSize().height);
				root.setAttribute("SCREENX", ""
						+ (int) HeroDesigner.getAppFrame()
								.getLocationOnScreen().getX());
				root.setAttribute("SCREENY", ""
						+ (int) HeroDesigner.getAppFrame()
								.getLocationOnScreen().getY());
			} else {
				root.setAttribute("SIZEX", "" + sizeX);
				root.setAttribute("SIZEY", "" + sizeY);
				root.setAttribute("SCREENX", screenX + "");
				root.setAttribute("SCREENY", screenY + "");
			}
			root.setAttribute("MINIMUM_HEAP_SIZE", "" + minimumHeapSize);
			root.setAttribute("MAXIMUM_HEAP_SIZE", "" + maximumHeapSize);

			Element sources = new Element("SOURCES");
			for (int i = 0; i < getSources().size(); i++) {
				String val = getSources().get(i).toString();
				Element source = new Element("SOURCE");
				source.setText(val);
				sources.addContent(source);
			}
			root.addContent(sources);

			Enumeration enumer = tearOffPrefs.keys();
			while (enumer.hasMoreElements()) {
				String title = enumer.nextElement().toString();
				Integer[] vals = tearOffPrefs.get(title);
				title = adjustTitle(title);
				root.setAttribute(title + "WIDTH", vals[0].toString());
				root.setAttribute(title + "HEIGHT", vals[1].toString());
				root.setAttribute(title + "X", vals[2].toString());
				root.setAttribute(title + "Y", vals[3].toString());
				root.setAttribute(title + "TORN", vals[4].toString());
			}
			if (browserExecutablePath != null
					&& browserExecutablePath.trim().length() > 0) {
				root.setAttribute("BROWSER_PATH", browserExecutablePath);
			}
			root.setAttribute("REFRESH_TEMPLATE_ON_RESTORE", ""
					+ refreshTemplateOnRestore);
			root.setAttribute("PROMPT_TO_EXPORT_IMAGE", ""
					+ (promptToExportImage ? "YES" : "NO"));
			root.setAttribute("FLAG_FORCED_MODIFIERS", ""
					+ (flagForcedModifiers ? "YES" : "NO"));
			root.setAttribute("SHOW_POPUP_DEFINITIONS", ""
					+ showPopupDefinitions);
			root.setAttribute("SHOW_EQUIPMENT_PREFABS_ON_POWERS", ""
					+ showEquipmentPrefabsOnPowers);
			root.setAttribute("SHOW_POWERS_PREFABS_ON_EQUIPMENT", ""
					+ showPowersPrefabsOnEquipment);
			root.setAttribute("REFRESH_RULES_ON_RESTORE", ""
					+ refreshRulesOnRestore);
			root.setAttribute(
					"SKILLSLIDER",
					""
							+ HeroDesigner.getInstance().mainPanel.skillsPanel.mainSplit
									.getDividerLocation());
			root.setAttribute(
					"PERKSLIDER",
					""
							+ HeroDesigner.getInstance().mainPanel.perksPanel.mainSplit
									.getDividerLocation());
			root.setAttribute(
					"TALENTSLIDER",
					""
							+ HeroDesigner.getInstance().mainPanel.talentsPanel.mainSplit
									.getDividerLocation());
			root.setAttribute(
					"MARTIALARTSLIDER",
					""
							+ HeroDesigner.getInstance().mainPanel.maneuversPanel.mainSplit
									.getDividerLocation());
			root.setAttribute(
					"POWERSLIDER",
					""
							+ HeroDesigner.getInstance().mainPanel.powersPanel.mainSplit
									.getDividerLocation());
			root.setAttribute(
					"DISADSLIDER",
					""
							+ HeroDesigner.getInstance().mainPanel.disadsPanel.mainSplit
									.getDividerLocation());
			root.setAttribute(
					"EQUIPMENTSLIDER",
					""
							+ HeroDesigner.getInstance().mainPanel.equipmentPanel.mainSplit
									.getDividerLocation());
			root.setAttribute("MAX_MEMORY", "" + maxMemory);
			if (saveDir != null) {
				root.setAttribute("SAVEDIR", saveDir);
			}
			if (exportDir != null) {
				root.setAttribute("EXPORTDIR", exportDir);
			}
			if (imageDir != null) {
				root.setAttribute("IMAGEDIR", imageDir);
			}
			if (templateDir != null) {
				root.setAttribute("TEMPLATEDIR", templateDir);
			}
			if (defaultRulesDir != null) {
				root.setAttribute("DEFAULTRULESDIR", defaultRulesDir);
			}
			if (defaultExportDir != null) {
				root.setAttribute("DEFAULTEXPORTDIR", defaultExportDir);
			}
			if (prefabDir != null) {
				root.setAttribute("PREFABDIR", prefabDir);
			}
			if (rulesDir != null) {
				root.setAttribute("RULESDIR", rulesDir);
			}
			if (lastRule != null) {
				root.setAttribute("LASTRULE", lastRule);
			}
			root.setAttribute("FRAME_STATE", ""
					+ HeroDesigner.getAppFrame().getExtendedState());
			root.setAttribute("TAB_POSITION", ""
					+ HeroDesigner.getInstance().mainPanel.getTabPlacement());
			root.setAttribute("LOAD_CHARS", loadCharacters ? "Yes" : "No");
			root.setAttribute("LOAD_PREFABS", loadPrefabs ? "Yes" : "No");
			root.setAttribute("RESTORE_WINDOW", restoreWindow ? "Yes" : "No");
			root.setAttribute("REMEMBER_DIALOG", rememberDialogPosition ? "Yes"
					: "No");
			root.setAttribute("MODIFIER_INTELLIGENCE",
					modifierIntelligenceOn ? "Yes" : "No");
			root.setAttribute("CHECK_MODS_DURING_EDIT", checkDuringEdit ? "Yes"
					: "No");
			root.setAttribute("REMOVE_ILLEGAL_MODS", removeIllegalMods ? "Yes"
					: "No");
			root.setAttribute("METRIC", metric ? "Yes" : "No");
			root.setAttribute("DISPLAYACTIVEPOINTS",
					displayActivePoints ? "Yes" : "No");
			root.setAttribute("USE_ABBREVIATIONS", useAbbreviations ? "Yes"
					: "No");
			root.setAttribute("USE_QUICKASSIGN", useQuickAssign ? "Yes" : "No");
			root.setAttribute("CONFIRM_DELETE", confirmDelete ? "Yes" : "No");
			root.setAttribute("WARN_ON_MULTIPLE", warnOnMultiple ? "Yes" : "No");
			root.setAttribute("SHOW_COMMON_LIMITATIONS",
					showCommonLimitations ? "Yes" : "No");
			root.setAttribute("USE_WG", useWG ? "Yes" : "No");
			root.setAttribute("NUMBERDIGITSROUNDING", ""
					+ numberDigitsForRounding);
			root.setAttribute("DIALOGX", "" + dialogX);
			root.setAttribute("DIALOGY", "" + dialogY);
			root.setAttribute("DIALOGSCREENX", "" + dialogScreenX);
			root.setAttribute("DIALOGSCREENY", "" + dialogScreenY);
			root.setAttribute("MODX", "" + modX);
			root.setAttribute("MODY", "" + modY);
			root.setAttribute("MODSCREENX", "" + modScreenX);
			root.setAttribute("MODSCREENY", "" + modScreenY);
			root.setAttribute("EXPORTTEMPLATEDIR", exportTemplateDir);

			if (defaultAIFormatPath != null) {
				root.setAttribute("DEFAULT_AI_FORMAT", defaultAIFormatPath);
			}
			if (defaultAutomatonFormatPath != null) {
				root.setAttribute("DEFAULT_AUTOMATON_FORMAT",
						defaultAutomatonFormatPath);
			}
			if (defaultBaseFormatPath != null) {
				root.setAttribute("DEFAULT_BASE_FORMAT", defaultBaseFormatPath);
			}
			if (defaultComputerFormatPath != null) {
				root.setAttribute("DEFAULT_COMPUTER_FORMAT",
						defaultComputerFormatPath);
			}
			if (defaultHeroicFormatPath != null) {
				root.setAttribute("DEFAULT_HEROIC_FORMAT",
						defaultHeroicFormatPath);
			}
			if (defaultNormalFormatPath != null) {
				root.setAttribute("DEFAULT_NORMAL_FORMAT",
						defaultNormalFormatPath);
			}
			if (defaultSuperheroicFormatPath != null) {
				root.setAttribute("DEFAULT_SUPERHEROIC_FORMAT",
						defaultSuperheroicFormatPath);
			}
			if (defaultVehicleFormatPath != null) {
				root.setAttribute("DEFAULT_VEHICLE_FORMAT",
						defaultVehicleFormatPath);
			}

			for (String f : recentFiles) {
				Element recent = new Element("RECENT_FILE");
				recent.addContent(f);
				root.addContent(recent);
			}
			for (Hero h : HeroDesigner.getInstance().openHeroes) {
				Element character = new Element("CHARACTER");
				if (h.getSaveFile() != null) {
					character.setAttribute("FILE_LOC", h.getSaveFile()
							.getAbsolutePath());
					root.addContent(character);
				}
			}
			for (Prefab h : HeroDesigner.getInstance().loadedPrefabs) {
				Element character = new Element("PREFAB");
				if (h.getSaveFile() != null) {
					character.setAttribute("FILE_LOC", h.getSaveFile()
							.getAbsolutePath());
					root.addContent(character);
				}
			}
			// add in the "recently selected" list of Modifiers...
			ArrayList<Modifier> mods = AvailableModifiersDialog
					.getRecentlySelectedList();
			if (mods != null) {
				for (Modifier mod : mods) {
					Element modXML = mod.getSaveXML();
					root.addContent(modXML);
				}
			}
			Format format = Format.getPrettyFormat();
			format.setEncoding("UTF-8");
			XMLOutputter outputter = new XMLOutputter(format);
			FileOutputStream out = new FileOutputStream("appPrefs.xml");
			outputter.output(new Document(root), out);
			out.close();
		} catch (IOException ex) {
		}
	}

	public int getMinimumHeapSize() {
		return minimumHeapSize;
	}

	public void setMinimumHeapSize(int pMinimumHeapSize) {
		minimumHeapSize = pMinimumHeapSize;
	}

	public int getMaximumHeapSize() {
		return maximumHeapSize;
	}

	public void setMaximumHeapSize(int pMaximumHeapSize) {
		maximumHeapSize = pMaximumHeapSize;
	}

	public void setRefreshTemplateOnRestore(int val) {
		if (val < 1 || val > 3) {
			return;
		}
		refreshTemplateOnRestore = val;
	}

	public int getRefreshTemplateOnRestore() {
		return refreshTemplateOnRestore;
	}

	public void setRefreshRulesOnRestore(int val) {
		if (val < 1 || val > 3) {
			return;
		}
		refreshRulesOnRestore = val;
	}

	public int getRefreshRulesOnRestore() {
		return refreshRulesOnRestore;
	}

	public String getLastRule() {
		if (lastRule == null) {
			lastRule = "";
		}
		if (lastRule.trim().length() > 0) {
			File check = new File(lastRule);
			if (check.exists() && check.isFile()) {
				return lastRule;
			}
			return "";
		}
		return lastRule;
	}

	public void setLastRule(String val) {
		if (val == null) {
			lastRule = "";
		} else {
			lastRule = val;
		}
	}

	public boolean useWG() {
		return useWG;
	}

	public void setUseWG(boolean val) {
		useWG = val;
	}

	public boolean useQuickAssign() {
		return useQuickAssign;
	}

	public void setUseQuickAssign(boolean val) {
		useQuickAssign = val;
	}

	public boolean confirmDelete() {
		return confirmDelete;
	}

	public boolean warnOnMultiple() {
		return warnOnMultiple;
	}

	public boolean showCommonLimitations() {
		return showCommonLimitations;
	}

	public void setConfirmDelete(boolean val) {
		confirmDelete = val;
	}

	public void setWarnOnMultiple(boolean val) {
		warnOnMultiple = val;
	}

	public void setShowCommonLimitations(boolean val) {
		showCommonLimitations = val;
	}

	public boolean useAbbreviations() {
		return useAbbreviations;
	}

	public void setUseAbbreviations(boolean val) {
		useAbbreviations = val;
	}

	public boolean isMetric() {
		return metric;
	}

	public void setMetric(boolean val) {
		metric = val;
	}

	public boolean displayActivePoints() {
		return displayActivePoints;
	}

	public void setDisplayActivePoints(boolean val) {
		displayActivePoints = val;
	}

	public int getDialogScreenX() {
		return dialogScreenX;
	}

	public int getDialogScreenY() {
		return dialogScreenY;
	}

	public int getDialogX() {
		return dialogX;
	}

	public int getDialogY() {
		return dialogY;
	}

	public String getExportDir() {
		return exportDir;
	}

	public String getImageDir() {
		return imageDir;
	}

	public boolean isLoadCharacters() {
		return loadCharacters;
	}

	public boolean isLoadPrefabs() {
		return loadPrefabs;
	}

	public int getMaxMemory() {
		return maxMemory;
	}

	public int getNumberDigitsForRounding() {
		return numberDigitsForRounding;
	}

	public String getPrefabDir() {
		return prefabDir;
	}

	public String getRulesDir() {
		return rulesDir;
	}

	public boolean isRememberDialogPosition() {
		return rememberDialogPosition;
	}

	public boolean isRestoreWindow() {
		return restoreWindow;
	}

	public String getSaveDir() {
		return saveDir;
	}

	public int getScreenX() {
		return screenX;
	}

	public int getScreenY() {
		return screenY;
	}

	public int getSizeX() {
		return sizeX;
	}

	public int getSizeY() {
		return sizeY;
	}

	public int getState() {
		return state;
	}

	public String getTemplateDir() {
		return templateDir;
	}

	public String getDefaultRulesDir() {
		return defaultRulesDir;
	}

	public String getDefaultExportDir() {
		return defaultExportDir;
	}

	public void setDialogScreenX(int i) {
		dialogScreenX = i;
	}

	public void setDialogScreenY(int i) {
		dialogScreenY = i;
	}

	public void setDialogX(int i) {
		dialogX = i;
	}

	public void setDialogY(int i) {
		dialogY = i;
	}

	public void setExportDir(String string) {
		exportDir = string;
	}

	public void setImageDir(String string) {
		imageDir = string;
	}

	public void setLoadCharacters(boolean b) {
		loadCharacters = b;
	}

	public void setLoadPrefabs(boolean b) {
		loadPrefabs = b;
	}

	public void setMaxMemory(int i) {
		maxMemory = i;
	}

	public void setNumberDigitsForRounding(int i) {
		numberDigitsForRounding = i;
	}

	public void setPrefabDir(String string) {
		prefabDir = string;
	}

	public void setRulesDir(String dir) {
		rulesDir = dir;
	}

	public void setRememberDialogPosition(boolean b) {
		rememberDialogPosition = b;
	}

	public void setRestoreWindow(boolean b) {
		restoreWindow = b;
	}

	public void setSaveDir(String string) {
		saveDir = string;
	}

	public void setScreenX(int i) {
		screenX = i;
	}

	public void setScreenY(int i) {
		screenY = i;
	}

	public void setSizeX(int i) {
		sizeX = i;
	}

	public void setSizeY(int i) {
		sizeY = i;
	}

	public void setState(int i) {
		state = i;
	}

	public void setTemplateDir(String string) {
		templateDir = string;
	}

	public void setDefaultRulesDir(String val) {
		defaultRulesDir = val;
	}

	public void setDefaultExportDir(String val) {
		defaultExportDir = val;
	}

	public String getExportTemplateDir() {
		return exportTemplateDir;
	}

	public void setExportTemplateDir(String string) {
		exportTemplateDir = string;
	}

	public boolean isModifierIntelligenceOn() {
		return modifierIntelligenceOn;
	}

	public boolean checkModsDuringEdit() {
		if (!modifierIntelligenceOn) {
			return false;
		}
		return checkDuringEdit;
	}

	public boolean removeIllegalMods() {
		if (!checkModsDuringEdit()) {
			return false;
		}
		return removeIllegalMods;
	}

	public void setModifierIntelligenceOn(boolean b) {
		modifierIntelligenceOn = b;
	}

	public void setCheckModsDuringEdit(boolean b) {
		checkDuringEdit = b;
	}

	public void setRemoveIllegalMods(boolean b) {
		removeIllegalMods = b;
	}

	public int getModScreenX() {
		return modScreenX;
	}

	public int getModScreenY() {
		return modScreenY;
	}

	public int getModX() {
		return modX;
	}

	public int getModY() {
		return modY;
	}

	public void setModScreenX(int i) {
		modScreenX = i;
	}

	public void setModScreenY(int i) {
		modScreenY = i;
	}

	public void setModX(int i) {
		modX = i;
	}

	public void setModY(int i) {
		modY = i;
	}

	public String getDefaultAIFormatPath() {
		return defaultAIFormatPath;
	}

	public void setDefaultAIFormatPath(String pDefaultAIFormatPath) {
		defaultAIFormatPath = pDefaultAIFormatPath;
	}

	public String getDefaultAutomatonFormatPath() {
		return defaultAutomatonFormatPath;
	}

	public void setDefaultAutomatonFormatPath(String pDefaultAutomatonFormatPath) {
		defaultAutomatonFormatPath = pDefaultAutomatonFormatPath;
	}

	public String getDefaultBaseFormatPath() {
		return defaultBaseFormatPath;
	}

	public void setDefaultBaseFormatPath(String pDefaultBaseFormatPath) {
		defaultBaseFormatPath = pDefaultBaseFormatPath;
	}

	public String getDefaultComputerFormatPath() {
		return defaultComputerFormatPath;
	}

	public void setDefaultComputerFormatPath(String pDefaultComputerFormatPath) {
		defaultComputerFormatPath = pDefaultComputerFormatPath;
	}

	public String getDefaultHeroicFormatPath() {
		return defaultHeroicFormatPath;
	}

	public void setDefaultHeroicFormatPath(String pDefaultHeroicFormatPath) {
		defaultHeroicFormatPath = pDefaultHeroicFormatPath;
	}

	public String getDefaultNormalFormatPath() {
		return defaultNormalFormatPath;
	}

	public void setDefaultNormalFormatPath(String pDefaultNormalFormatPath) {
		defaultNormalFormatPath = pDefaultNormalFormatPath;
	}

	public String getDefaultSuperheroicFormatPath() {
		return defaultSuperheroicFormatPath;
	}

	public void setDefaultSuperheroicFormatPath(
			String pDefaultSuperheroicFormatPath) {
		defaultSuperheroicFormatPath = pDefaultSuperheroicFormatPath;
	}

	public String getDefaultVehicleFormatPath() {
		return defaultVehicleFormatPath;
	}

	public void setDefaultVehicleFormatPath(String pDefaultVehicleFormatPath) {
		defaultVehicleFormatPath = pDefaultVehicleFormatPath;
	}
}